/*
 *	WBRun.c - Copyright  1990 by S.R. & P.C.
 *
 *	Created:	28 Apr 1991  20:17:57
 *	Modified:	06 Mar 1993  19:47:17
 *
 *	Make>> sc <file>.c
 *	Make>> slink LIB:cs.o <file>.o SC SD ND BATCH QUIET TO <file> LIB LIB:startup.lib
 *	Make>> Protect <file> P ADD
 */

#include <libraries/ParMBase.h>
#include <proto/ParM.h>

char *Template = "Prog/A,Args/M,STACK/K/N,PRI/K/N,DELAY/K/N";
char *CliHelp = "Usage: WBRun Prog [args] [STACK size] [PRI pri] [DELAY sec]\n";

struct ParMBase *ParMBase;


#define ARG_STACK	2
#define ARG_PRI		3
#define ARG_DELAY	4


long Main(char *argv[], struct WBStartup *WBenchMsg)
{
	struct Process *pp;
	struct Extended_WBStartup *EWBS = NULL;
	char **args;
	long argl[5];	/* 0 and 1 not used */
	long DefaultStack, i, NumArg=1, err = 20;
	APTR OldWindowPtr;

	if (!(ParMBase = (struct ParMBase *)OpenLibrary("parm.library", 6L))) {
		PutStr("Requires parm.library V6");
		return 20;
	}
	pp = (struct Process *)SysBase->ThisTask;
	OldWindowPtr = pp->pr_WindowPtr;
	pp->pr_WindowPtr = (APTR)-1;
	DefaultStack = Cli()->cli_DefaultStack << 2;

	/* Init array of long int type arguments */
	for(i=2;i<5;i++)
		argl[i] = (argv[i]) ? *(long *)argv[i] : 0;
	if (argl[ARG_STACK])
		DefaultStack = argl[ARG_STACK];

	/* count args */
	if (args = (char **)argv[1]) {
		while(*args++)
			NumArg++;
	}

	if (EWBS = AllocWBStartup(NumArg)) {
		if (MakeWBArg(NULL, EWBS->WBStartup.sm_ArgList, argv[0])) {
			if (args = (char **)argv[1]) {
				i = 1;
				while(*args) {
					if (!MakeWBArg(NULL, &EWBS->WBStartup.sm_ArgList[i++], *args++))
						goto Exit;
				}
			}
			if (GetTool(NULL, EWBS, DefaultStack)) {
				WBRunTags(NULL, EWBS, WBRun_Pri, argl[ARG_PRI], TAG_DONE);
				Delay(argl[ARG_DELAY]*50);
				err = 0;
			}
		}
	}

Exit:
	FreeRepliedWBMessages();
	if (err && EWBS)
		WBFree(EWBS);
	pp->pr_WindowPtr = OldWindowPtr;
	CloseLibrary(ParMBase);
	return err;
}


