		opt	c-,l-,o1+,o2+,ow-

*****************************************************************************
*                                                                           *
*                                 A S H I D O                               *
*                               ~~~~~~~~~~~~~~~                             *
*                      by Aragorn of CLUSTER / HAWK 1990                   *
*                                                                           *
*  Planned on 22.11.1990, Started on 04.11.1990, last update on 10.12.1990  *
*                                                                           *
*****************************************************************************
*                                                                           *
*   Structure of a stage:  12x7 plots (bytes), one byte is divided into     *
*   two nibbles: xxxxyyyy, where x means the number of the color of the     *
*   tile and y the pattern of the tile (see label 'Area').                  *
*   Levels of difficulty:                                                   *
*                                                                           *
*          Level               Clock     Board     Touch                    *
*      ------------------------------------------------------               *
*        Freestyle               -         -         -                      *
*        Scorer                  X         -         -                      *
*        Explorer                -         X         -                      *
*        Pioneer                 X         X         -                      *
*        Hero                    -         X         X                      *
*        Einstein                X         X         X                      *
*                                                                           *
*  For the different boards look at the label 'Table_1', -1 means empty     *
*  plot.Use the '<<'-opcode to create the high-nibble, '!' for the low one. *
*                                                                           *
*****************************************************************************

			incdir	ram:include/
			include	libraries/dosextens.i
			include	exec/exec_lib.i
			include	exec/execbase.i

OpenLibrary	equ	-552
CloseLibrary	equ	-414
AllocMem	equ	-198
FreeMem		equ	-210
Forbid		equ	-132
Permit		equ	-138
FindTask	equ	-294
Output		equ	-60
Open		equ	-30
Close		equ	-36
Read		equ	-42
Write		equ	-48
Delay		equ	-198

BLTCON0		equ	$040
BLTCON1		equ	$042
BLTAFWM		equ	$044
BLTALWM		equ	$046
BLTCPTH		equ	$048
BLTBPTH		equ	$04C
BLTAPTH		equ	$050
BLTDPTH		equ	$054
BLTSIZE		equ	$058
BLTCMOD		equ	$060
BLTBMOD		equ	$062
BLTAMOD		equ	$064
BLTDMOD		equ	$066
DIWSTRT		equ	$08E
DIWSTOP		equ	$090
DDFSTRT		equ	$092
DDFSTOP		equ	$094
BPL1PTH		equ	$0E0
BPL1PTL		equ	$0E2
BPL2PTH		equ	$0E4
BPL2PTL		equ	$0E6
BPL3PTH		equ	$0E8
BPL3PTL		equ	$0EA
BPL4PTH		equ	$0EC
BPL4PTL		equ	$0EE
BPL5PTH		equ	$0F0
BPL5PTL		equ	$0F2
BPL6PTH		equ	$0F4
BPL6PTL		equ	$0F6
BPL1MOD		equ	$108
BPL2MOD		equ	$10A
BPLCON0		equ	$100
BPLCON1		equ	$102
BPLCON2		equ	$104
DMACONW		equ	$096
DMACONR		equ	$002
COP1LCH		equ	$080
COPJMP1		equ	$088
BLTAPTL		equ	$052
BLTADAT		equ	$074
BLTBDAT		equ	$072
JOY0DAT		equ	$00A
JOY1DAT		equ	$00C
SPR0PTH		equ	$120
CIAAPRA		equ	$001
VHPOSR		equ	$006
STARTLIST	equ	38

		SECTION	"Startup",CODE

		movem.l	d0/a0,-(sp)
		clr.l	_WBenchMsg
		sub.l	a1,a1
		CALLEXEC FindTask
		move.l	d0,a4
		tst.l	pr_CLI(a4)
		beq.s	_WB
		movem.l	(sp)+,d0/a0
		bra.s	_run
_WB		lea	pr_MsgPort(a4),a0
		CALLEXEC WaitPort
		lea	pr_MsgPort(a4),a0
		CALLEXEC GetMsg
		move.l	d0,_WBenchMsg
		movem.l	(sp)+,d0/a0
_run		jsr	_Main
		move.l	d0,-(sp)
		tst.l	_WBenchMsg
		beq.s	_Exit
		CALLEXEC Forbid
		move.l	_WBenchMsg(pc),a1
		CALLEXEC ReplyMsg
_Exit		move.l	(sp)+,d0
		rts

_WBenchMsg	ds.l	1

		SECTION	"Ashido",CODE

_Main		move.l	4.w,a6			allocate mem and open libs
		lea	DOSName,a1
		moveq	#0,d0
		jsr	OpenLibrary(a6)
		move.l	d0,DosBase
		lea	$dff000,a5
		move.l	#2*5*256*40+10000+4+6*4+4+8,d0
		move.l	#$10002,d1
		jsr	AllocMem(a6)
		tst.l	d0
		beq	Error_1
		move.l	d0,Mem
		move.l	d0,Plane_1
		add.l	#5*256*40,d0
		move.l	d0,Plane_2
		add.l	#5*256*40,d0
		move.l	d0,Copper
		add.l	#10000,d0
		move.l	d0,Sprite
		add.l	#4+6*4+4,d0
		move.l	d0,Empty

		move.l	DosBase,a6
		move.l	#Filename,d1		try to load highscores
		move.l	#1005,d2
		jsr	Open(a6)
		tst.l	d0
		beq.s	.No_High
		move.l	d0,d7
		move.l	d7,d1
		move.l	#Highscores,d2
		move.l	#6*6*24,d3
		jsr	Read(a6)
		move.l	d7,d1
		jsr	Close(a6)
.No_High	move.l	4.w,a6

		bsr	Create_Mask		create tile-masks
		bsr	Set_RND			set RND to rnd (uh...)

		move.l	Copper,a0		create copperlist
		lea	Colortable_1,a1
		move.l	#Cols_1/2-1,d0
		move.l	#$210ffffe,d1
SetCols_1	move.l	d1,(a0)+
		move.w	#$180,(a0)+
		move.w	(a1)+,(a0)+
		add.l	#$01000000,d1
		dbra	d0,SetCols_1
		move.l	#$fffffffe,(a0)

		jsr	Forbid(a6)		set registers
		move.w	#$7fff,DMACONW(a5)
		move.l	Copper,COP1LCH(a5)
		clr.w	COPJMP1(a5)
		move.w	#$3081,DIWSTRT(a5)
		move.w 	#$30c1,DIWSTOP(a5)
		move.w  #$0038,DDFSTRT(a5)
		move.w  #$00d0,DDFSTOP(a5)
		move.w  #%0101000000000000,BPLCON0(a5)
		move.w	#0,BPLCON1(a5)
		move.w	#%0000000000100100,BPLCON2(a5)
		move.w	#0,BPL1MOD(a5)
		move.w	#0,BPL2MOD(a5)

		move.l	Sprite,a2		create sprites
		move.w	#0,(a2)+
		move.w	#0,(a2)+
		lea	sprptr,a1
		moveq	#6*2-1,d0
setptr		move.w	(a1)+,(a2)+
		dbra	d0,setptr
		move.w	#0,(a2)+
		move.w	#0,(a2)+
		move.l	Empty,a1
		move.l	#0,(a1)+
		move.l	#0,(a1)+
		move.l	Sprite,a0
		move.l	#268,d0
		move.l	#160,d1
		move.l	#274,d2
		move.l	#0,d3
		bsr	Set_Spritepos
		move.l	#268,ptr_x
		move.l	#268,prev_x
		move.l	#160,ptr_y
		move.l	#160,prev_y

		move.w	#%1000011111111111,DMACONW(a5)

		move.l	#0,Clockflag		set IRQ-flags + IRQ-ptr
		move.l	#0,Scrollflag
		bchg	#1,$bfe001
		jsr	Start_Muzak
		move.l	$6c,OldIRQ+2
		move.l	#NewIRQ,$6c

		move.l	#5,GameMode		Mode = Einstein
		move.l	#0,The_Flag		clear the mysterious flag

Title		move.l	#0,Clockflag
		bsr	Clear_Plane
		move.l	#256*44,bpsize
		move.w  #%0100000000000000,BPLCON0(a5)
		move.w	#4,BPL1MOD(a5)		change into overscan
		move.w	#4,BPL2MOD(a5)		for scrolltext
		move.l	#1,Colorflag

		lea	Titleline_1,a0		give out ashido
		move.l	Plane_1,a1
		addq.l	#2,a1
		bsr	BigPrint
		move.l	#Text,vektor		start scrolltext
		move.l	#8,Smooth
		move.l	#1,Scrollflag

Page_I		lea	Page_1,a0
		moveq	#7,d7
		move.l	#38*44,d6
.PrintPage	move.l	Plane_1,a1
		add.l	d6,a1
		bsr	Print
		add.l	#16*44,d6
		dbra	d7,.PrintPage
		move.l	#$70000,d0
		move.b	#0,$bfec01
.Wait		subq.l	#1,d0
		beq.s	Page_II
		move.b	$bfec01,d1
		beq.s	.NoKey
		bsr	Check_Key
		tst.l	d1
		bne.s	Page_II
.NoKey		btst	#6,$bfe001
		bne.s	.Wait
		bra	Start_Game

Page_II		lea	Page_2,a0
		moveq	#7,d7
		move.l	#38*44,d6
.PrintPage	move.l	Plane_1,a1
		add.l	d6,a1
		bsr	Print
		add.l	#16*44,d6
		dbra	d7,.PrintPage
		lea	Modi,a0
		move.l	Plane_1,a1
		add.l	#38*44,a1
		move.l	GameMode,d0
		mulu	#41,d0
		add.l	d0,a0
		bsr	Print
		move.l	#$70000,d0
		move.b	#0,$bfec01
.Wait		subq.l	#1,d0
		beq.s	Page_Highs
		move.b	$bfec01,d1
		beq.s	.NoKey
		bsr	Check_Key
		tst.l	d1
		bne.s	Page_II
.NoKey		btst	#6,$bfe001
		bne.s	.Wait
		bra	Start_Game

Page_Highs	lea	High_strings,a0
		move.l	GameMode,d0
		mulu	#41,d0
		add.l	d0,a0
		move.l	Plane_1,a1
		add.l	#38*44,a1
		bsr	Print
		lea	Empty_line,a0
		move.l	Plane_1,a1
		add.l	#54*44,a1
		bsr	Print
		lea	Highscores,a0
		move.l	GameMode,d0
		mulu	#6*24,d0
		add.l	d0,a0
		moveq	#5,d7
		move.l	#70*44,d6
.Print_Highs	movem.l	d0-d7/a0-a6,-(sp)
		lea	TextBuffer,a1
		moveq	#39,d0
.Clear_Buffer	move.b	#" ",(a1)+
		dbra	d0,.Clear_Buffer
		move.b	#0,(a1)
		move.l	(a0)+,d0
		move.l	#5,d1			give out Scores
		moveq	#0,d2
		lea	TextBuffer+6,a0
		bsr	BinDec
		move.b	#" ",5(a0)
		movem.l	(sp),d0-d7/a0-a6
		lea	TextBuffer+16,a1
		addq.l	#4,a0
		moveq	#23,d0
.CopyName	move.b	(a0)+,(a1)+
		dbra	d0,.CopyName
		lea	TextBuffer,a0
		move.l	Plane_1,a1
		add.l	d6,a1
		bsr	Print
		movem.l	(sp)+,d0-d7/a0-a6
		add.l	#24,a0
		add.l	#16*44,d6
		dbra	d7,.Print_Highs
		move.l	#$70000,d0
		move.b	#0,$bfec01
.Wait		subq.l	#1,d0
		beq.s	Page_III
		move.b	$bfec01,d1
		beq.s	.NoKey
		bsr	Check_Key
		tst.l	d1
		bne	Page_II
.NoKey		btst	#6,$bfe001
		bne.s	.Wait
		bra	Start_Game

Page_III	lea	Page_3,a0
		moveq	#7,d7
		move.l	#38*44,d6
.PrintPage	move.l	Plane_1,a1
		add.l	d6,a1
		bsr	Print
		add.l	#16*44,d6
		dbra	d7,.PrintPage
		move.l	#$70000,d0
		move.b	#0,$bfec01
.Wait		subq.l	#1,d0
		beq.s	Page_IV
		move.b	$bfec01,d1
		beq.s	.NoKey
		bsr.s	Check_Key
		tst.l	d1
		bne	Page_II
.NoKey		btst	#6,$bfe001
		bne.s	.Wait
		bra	Start_Game

Page_IV		lea	Page_4,a0
		moveq	#7,d7
		move.l	#38*44,d6
.PrintPage	move.l	Plane_1,a1
		add.l	d6,a1
		bsr	Print
		add.l	#16*44,d6
		dbra	d7,.PrintPage
		move.l	#$70000,d0
		move.b	#0,$bfec01
.Wait		subq.l	#1,d0
		beq	Page_I
		move.b	$bfec01,d1
		beq.s	.NoKey
		bsr.s	Check_Key
		tst.l	d1
		bne	Page_II
.NoKey		btst	#6,$bfe001
		bne.s	.Wait
		bra	Start_Game

Check_Key	btst	#0,$bfec01		wait until release
		bne.s	Check_Key
		move.b	#0,$bfec01
		cmp.b	#$75,d1			ESC ?
		bne.s	.Next_Check
		move.l	(sp)+,d1		kill return-address
		bra	End_Game		and end game
.Next_Check	cmp.b	#$5f,d1
		bhi.s	.The_Routine
		cmp.b	#$55,d1
		blt.s	.The_Routine
		sub.b	#$53,d1
		lsr.l	#1,d1
		move.l	#6,d2
		sub.b	d1,d2
		move.l	d2,GameMode
		move.l	#1,d1
		rts
.The_Routine	lea	The_Word,a0
		move.l	The_Counter,d2
		move.b	(a0,d2),d2
		cmp.b	d1,d2
		bne	.The_Reset
		addq.l	#1,The_Counter
		cmp.l	#6,The_Counter
		bne.s	.The_Return
		eor.l	#1,The_Flag
		move.l	#0,The_Counter
		tst.l	The_Flag
		bne.s	.The_Doom
		lea	.The_Page_1,a0
		moveq	#7,d7
		move.l	#38*44,d6
.PrintPage_1	move.l	Plane_1,a1
		add.l	d6,a1
		bsr	Print
		add.l	#16*44,d6
		dbra	d7,.PrintPage_1
		move.l	#$ffffff,d0
		bra.s	.The_Return
.The_Doom	lea	.The_Page_2,a0
		moveq	#7,d7
		move.l	#38*44,d6
.PrintPage_2	move.l	Plane_1,a1
		add.l	d6,a1
		bsr	Print
		add.l	#16*44,d6
		dbra	d7,.PrintPage_2
		move.l	#$ffffff,d0
.The_Return	move.l	#0,d1
		rts
.The_Reset	move.l	#0,The_Counter
		bra.s	.The_Return

.The_Page_2	dc.b	" GREETINGS, NOBLE PLAYER. YOU TYPED IN  ",0
		dc.b	"THE WORD THAT WILL GIVE YOU THE POWER TO",0
		dc.b	"  CHEAT THIS GAME.FEEL FREE TO USE THE  ",0
		dc.b	" FOLLOWING KEYS WHILE PLAYING THIS FINE ",0
		dc.b	" GAME:    C - TOGGLE CLOCK ON/OFF       ",0
		dc.b	"          S - SKIP DISPLAYED TILE       ",0
		dc.b	"          M - INCREASE MULTIPLIER       ",0
		dc.b	"          N - LEAVE ACTUAL BOARD.       ",0
		even
.The_Page_1	dc.b	" YOU MADE A WISE MOVE TO SWITCH OFF THE ",0
		dc.b	"BORING CHEATMODE THAT WOULD ONLY DESTROY",0
		dc.b	" THE COMPETITION TO GET THE BEST SCORE. ",0
		dc.b	"IF YOU ONLY USED IT TO SEE ALL BOARDS OR",0
		dc.b	" TO SEE WHAT HAPPENS I MUST BOW BEFORE  ",0
		dc.b	"YOU. OTHERWISE, IF YOU USED IT TO GET AN",0
		dc.b	"INCREDIBLE SCORE: SHAME ON YOU !!! NEVER",0
		dc.b	"USE IT AGAIN !!!     SIGNED ARAGORN [AW]",0
		even

The_Word	dc.b	$bd,$bf,$d3,$d9,$cf,$93	yeah, it's the magic word...
		even
The_Counter	ds.l	1
The_Flag	ds.l	1

Start_Game	bsr	Play
		bra	Title

End_Game	move.l	OldIRQ+2,$6c		reset IRQ-ptr
		jsr	Stop_Muzak
		bchg	#1,$bfe001

		lea	GFXName,a1		set WB-copperlist
		clr.l	d0
		jsr	OpenLibrary(a6)
		move.l	d0,a1
		move.l	STARTLIST(a1),COP1LCH(a5)
		clr.w	COPJMP1(a5)
		move.w	#$8060,DMACONW(a5)	reset registers
		jsr	CloseLibrary(a6)
		move.l	Mem,a1			free mem
		move.l	#2*5*256*40+10000+4+6*4+4+8,d0
		jsr	FreeMem(a6)
		jsr	Permit(a6)

_CLI		move.l	4.w,a6
		move.l	DosBase,a6		try to save scores
		move.l	#Filename,d1
		move.l	#1006,d2
		jsr	Open(a6)
		tst.l	d0
		beq.s	.NoSave
		move.l	d0,d7
		move.l	d7,d1
		move.l	#Highscores,d2
		move.l	#6*6*24,d3
		jsr	Write(a6)
		move.l	d7,d1
		jsr	Close(a6)
.NoSave		move.l	4.w,a6
		move.l	DosBase,a1		close libs and CLI
		jsr	CloseLibrary(a6)
		moveq	#0,d0
		rts

Error_1		move.l	DosBase,a6		give out error text
		jsr	Output(a6)
		move.l	d0,d1
		move.l	#Error_text,d2
		move.l	#Error_len,d3
		jsr	Write(a6)
		bra	_CLI

NewIRQ		movem.l	d0-d7/a0-a6,-(sp)
		move.l	Plane_1,d0		show bitplanes
		move.l	d0,BPL1PTH(a5)
		add.l	bpsize,d0
		move.l	d0,BPL2PTH(a5)
		add.l	bpsize,d0
		move.l	d0,BPL3PTH(a5)
		add.l	bpsize,d0
		move.l	d0,BPL4PTH(a5)
		add.l	bpsize,d0
		move.l	d0,BPL5PTH(a5)
		move.l	Sprite,SPR0PTH+28(a5)	show sprites
		move.l	Empty,SPR0PTH+0(a5)
		move.l	Empty,SPR0PTH+4(a5)
		move.l	Empty,SPR0PTH+4(a5)
		move.l	Empty,SPR0PTH+8(a5)
		move.l	Empty,SPR0PTH+12(a5)
		move.l	Empty,SPR0PTH+16(a5)
		move.l	Empty,SPR0PTH+20(a5)
		move.l	Empty,SPR0PTH+24(a5)

		lea	Colortable_2,a0		set colors
		lea	$dff180,a1
		moveq	#31,d0
.SetBackCols	move.w	(a0)+,(a1)+
		dbra	d0,.SetBackCols
		tst.l	Colorflag
		beq.s	.NoTitle
		lea	Colortable_3,a0		set scrollcolors
		lea	$dff180,a1
		moveq	#7,d0
.SetScrollCols	move.w	(a0)+,(a1)+
		dbra	d0,.SetScrollCols
.NoTitle
		bsr	CheckMouse		do mouse-pointer
		bsr	Do_Clock		do clock
		bsr.s	Do_Scroll		do scrolltext

		movem.l	(sp)+,d0-d7/a0-a6	and return
OldIRQ		jmp	$DEAD0			to death

Do_Scroll	tst.l	Scrollflag		really scroll ?
		bne.s	.Do_it
		rts
.Do_it		btst	#14,DMACONR(a5)		scroll smooth
		bne.s	.Do_it
		move.w	#%1110100111110000,BLTCON0(a5)
		move.w	#0,BLTCON1(a5)
		move.w	#0,BLTAMOD(a5)
		move.w	#0,BLTDMOD(a5)
		move.l	Plane_1,d0
		add.l	#174*44,d0
		moveq	#2,d1
.Smooth_it	btst	#14,DMACONR(a5)
		bne.s	.Smooth_it
		move.l	d0,BLTAPTH(a5)
		subq.l	#2,d0
		move.l	d0,BLTDPTH(a5)
		addq.l	#2,d0
		move.w	#25*64+22,BLTSIZE(a5)
		add.l	#256*44,d0
		dbra	d1,.Smooth_it
		subq.l	#1,Smooth
		beq.s	.NewLetter
		rts
.NewLetter	move.l	#12,Smooth
		move.l	vektor,a0
.GetChar	moveq	#0,d0
		move.b	(a0)+,d0
		bne.s	.NoRestart
		move.l	#Text,a0
		bra.s	.GetChar
.NoRestart	move.l	a0,vektor
		sub.b	#$20,d0
		mulu	#3*24*3,d0
		lea	Charset,a0
		add.l	d0,a0
		move.l	Plane_1,a1
		add.l	#174*44+40,a1
		moveq	#2,d0
.CopyChar_1	move.l	a1,a2
		moveq	#23,d1
.CopyChar_2	move.b	(a0)+,0(a2)
		move.b	(a0)+,1(a2)
		move.b	(a0)+,2(a2)
		add.l	#44,a2
		dbra	d1,.CopyChar_2
		add.l	#256*44,a1
		dbra	d0,.CopyChar_1
		rts

Clear_Plane	move.l	Plane_1,a0		clear plane
		move.l	#(5*256*10)-1,d0
.ClearPlane	move.l	#0,(a0)+
		dbra	d0,.ClearPlane
		rts				and return

Play		move.l	#0,Scrollflag		restore regs
		bsr	WaitBlt
		move.l	#256*40,bpsize
		move.w  #%0101000000000000,BPLCON0(a5)
		move.w	#0,BPL1MOD(a5)		change into normal
		move.w	#0,BPL2MOD(a5)		for playfield
		move.l	#0,Score		play a new game
		move.l	#0,Stage
		move.l	#1,Multiplier
.Play_Loop	bsr	Get_Ready
		bsr	Play_Stage
		move.l	#0,Clockflag
		tst.l	d0			stage solved or escaped ?
		bne	Game_Over
		bsr.s	Good
		bra.s	.Play_Loop
		rts

Good		bsr.s	Clear_Plane
		move.l	#0,Colorflag
		lea	Good_text,a0		give out congrats
		move.l	Plane_1,a1
		add.l	#60*40,a1
		bsr	Print
		lea	Good_text_2,a0
		move.l	Plane_1,a1
		add.l	#84*40,a1
		bsr	Print
		lea	Bonus_text,a0		give out bonus-text
		move.l	Plane_1,a1
		add.l	#108*40,a1
		bsr	Print
		move.l	Minutes,d0
		mulu	#6,d0
		move.l	Seconds,d1
		divu	#10,d1
		and.l	#$ffff,d1
		add.l	d1,d0
		move.l	Multiplier,d1
		mulu	d1,d0
		add.l	d0,Score
		move.l	#5,d1			give out bonus
		moveq	#0,d2
		lea	TextBuffer,a0
		bsr	BinDec
		move.l	Plane_1,a1
		add.l	#108*40+24,a1
		bsr	Print
		bsr	MBWait
		rts

Game_Over	move.l	#0,Colorflag
		bsr	Clear_Plane
		lea	GameOver_text,a0
		move.l	Plane_1,a1
		add.l	#86*40,a1
		bsr	Print
		move.l	Score,d0
		move.l	#5,d1			give out Scores
		moveq	#0,d2
		lea	GameOver_score+23,a0
		bsr	BinDec
		lea	GameOver_score,a0
		move.l	Plane_1,a1
		add.l	#110*40,a1
		bsr	Print
		bsr	MBWait
		move.l	Score,d1		check out highscore
		lea	Highscores,a0
		move.l	GameMode,d0
		mulu	#6*24,d0
		add.l	d0,a0
		move.l	#0,d0
.Compare_Scores	move.l	(a0)+,d2
		add.l	#20,a0
		cmp.l	d1,d2
		blt.s	.Highscore
		addq.l	#1,d0
		cmp.l	#6,d0
		bne.s	.Compare_Scores
		rts
.Highscore	sub.l	#24,a0
		cmp.l	#9,d0
		beq	.No_Trans
		lea	Highscores+5*24,a1
		move.l	GameMode,d1
		mulu	#6*24,d1
		add.l	d1,a1
		moveq	#5,d1
.Transfer	move.l	-24(a1),(a1)
		move.l	-20(a1),4(a1)
		move.l	-16(a1),8(a1)
		move.l	-12(a1),12(a1)
		move.l	-8(a1),16(a1)
		move.l	-4(a1),20(a1)
		sub.l	#24,a1
		subq.l	#1,d1
		cmp.l	d0,d1
		bne.s	.Transfer
.No_Trans	move.l	Score,(a0)+
		move.l	a0,Hiptr
		bsr	Clear_Plane
		lea	High_text_1,a0
		move.l	Plane_1,a1
		add.l	#86*40,a1
		bsr	Print
		lea	High_text_2,a0
		move.l	Plane_1,a1
		add.l	#110*40,a1
		bsr	Print
		move.l	#19,d0
		move.l	#110,d1
		lea	TextBuffer,a0
		move.l	#20,d2
		bsr	Input
		lea	TextBuffer,a0
		move.l	Hiptr,a1
		moveq	#19,d0
.RightBound	cmp.b	#0,(a0)
		beq	.Anonymous
		cmp.b	#" ",(a0)
		bne.s	.Start_Copy
		addq.l	#1,a0
		move.b	#" ",(a1)+
		dbra	d0,.RightBound
		bra	.Anonymous
.Start_Copy	cmp.b	#0,(a0)
		beq.s	.Clear_End
		move.b	(a0)+,(a1)+
		dbra	d0,.Start_Copy
		rts

.Clear_End	move.b	#" ",(a1)+
		dbra	d0,.Clear_End
		rts
.Anonymous	lea	Anonymous_text,a0
		moveq	#19,d0
.Copy_Ano	move.b	(a0)+,(a1)+
		dbra	d0,.Copy_Ano
		rts

Get_Ready	move.l	#0,Colorflag
		bsr	Clear_Plane
		lea	GetReady_text,a0
		move.l	Plane_1,a1
		add.l	#90*40,a1
		bsr	Print
		bsr.s	MBWait
		rts

MBWait		btst	#6,$bfe001
		bne.s	MBWait
.Release	btst	#6,$bfe001
		beq.s	.Release
		rts

Play_Stage	move.l	#0,Colorflag
		move.l	#0,Minutes
		move.l	#0,Seconds
		move.l	#62,Left		start a new stage !
		addq.l	#1,Stage
		lea	Table_1,a0		-> Empty stage
		cmp.l	#0,GameMode		set stage (if necessary)
		beq.s	.NoSet
		cmp.l	#1,GameMode
		beq.s	.NoSet
		subq.l	#6,Left			six tiles already on table
		move.l	Stage,d0
		cmp.l	#15,d0
		ble.s	.NoRND
		move.l	#15,d0
		bsr	Get_RND
		addq.l	#1,d0
.NoRND		mulu	#12*7,d0
		add.l	d0,a0
.NoSet		lea	Area,a1
		moveq	#12*7-1,d0
.Set_Area	move.b	(a0)+,(a1)+
		dbra	d0,.Set_Area
		lea	Statusline,a0		prepare playfield
		move.l	Plane_1,a1
		add.l	#184*40,a1
		bsr	Print
		bsr	Show_Board		give out board
		cmp.l	#0,GameMode		check out mode
		beq.s	.NoClock
		cmp.l	#2,GameMode
		beq.s	.NoClock
		cmp.l	#4,GameMode
		beq.s	.NoClock
		move.l	#4,Minutes
		move.l	#0,Seconds
		move.l	#1,Frames
		move.l	#1,Clockflag		start clock
.NoClock
Play_Loop	bsr	Show_Next		loop: next tile
		tst.l	Left			stage finished ?
		bmi	EndOfStage
		move.l	Score,d0		give out score
		move.l	#5,d1
		moveq	#0,d2
		lea	TextBuffer,a0
		bsr	BinDec
		move.l	Plane_1,a1
		add.l	#184*40+8,a1
		bsr	Print
		move.l	Multiplier,d0		and the multiplier
		move.l	#1,d1
		move.l	#0,d2
		lea	TextBuffer,a0
		bsr	BinDec
		move.l	Plane_1,a1
		add.l	#184*40+6,a1
		bsr	Print

.wait		tst.l	Minutes			check timer
		bne.s	.Time_Left
		tst.l	Seconds
		bne.s	.Time_Left
		cmp.l	#0,GameMode
		beq.s	.Time_Left
		cmp.l	#2,GameMode
		beq.s	.Time_Left
		cmp.l	#4,GameMode
		beq.s	.Time_Left
		bra	_End
.Time_Left	cmp.b	#$75,$BFEC01		wait...
		beq	_End
		tst.l	The_Flag		and the mysterious flag again
		beq.s	.No_The
		cmp.b	#$93,$BFEC01
		bne.s	.No_93
		move.l	#0,d0
		rts
.No_93		cmp.b	#$91,$BFEC01
		bne.s	.No_91
		cmp.l	#9,Multiplier
		beq.s	.No_91
		addq.l	#1,Multiplier
		move.b	#$90,$BFEC01
.No_91		cmp.b	#$bd,$BFEC01
		bne.s	.No_BD
		move.b	#$bc,$BFEC01
		bra	Play_Loop
.No_BD		cmp.b	#$99,$BFEC01
		bne.s	.No_99
		move.b	#$98,$BFEC01
		eor.l	#1,Clockflag
.No_99
.No_The		btst	#6,$bfe001
		bne	.wait

		move.l	ptr_x,d0		which plot was selected ?
		sub.l	#136,d0
		move.l	ptr_y,d1
		sub.l	#50,d1
		divu	#24,d0
		and.l	#$ffff,d0
		divu	#24,d1
		and.l	#$ffff,d0
		lea	Area,a0			get ptr on stage-plot
		add.l	d0,a0
		mulu	#12,d1
		add.l	d1,a0
		divu	#12,d1
		cmp.b	#-1,(a0)		occupied ?
		bne	.wait
		move.l	#0,Adder		Set adder to zero
		cmp.b	#0,d0			check out the neighbours
		beq.s	.NoCheck_1
		cmp.b	#-1,-1(a0)		occupied ?
		beq.s	.NoCheck_1
		addq.l	#1,Adder		add one to score
		move.b	-1(a0),d2		left one
		and.l	#15,d2
		cmp.l	Next_Tile,d2		same pattern ?
		beq.s	.NoCheck_1
		move.b	-1(a0),d2
		lsr.l	#4,d2
		and.l	#15,d2
		cmp.l	Next_Color,d2		same color ?
		beq.s	.NoCheck_1
		bra	.wait			cannot set this !
.NoCheck_1	cmp.b	#11,d0			check out the neighbours
		beq.s	.NoCheck_2
		cmp.b	#-1,1(a0)		occupied ?
		beq.s	.NoCheck_2
		addq.l	#1,Adder		add one to score
		move.b	1(a0),d2		right one
		and.l	#15,d2
		cmp.l	Next_Tile,d2		same pattern ?
		beq.s	.NoCheck_2
		move.b	1(a0),d2
		lsr.l	#4,d2
		and.l	#15,d2
		cmp.l	Next_Color,d2		same color ?
		beq.s	.NoCheck_2
		bra	.wait			cannot set this !
.NoCheck_2	cmp.b	#0,d1			check out the neighbours
		beq.s	.NoCheck_3
		cmp.b	#-1,-12(a0)		occupied ?
		beq.s	.NoCheck_3
		addq.l	#1,Adder		add one to score
		move.b	-12(a0),d2		upper one
		and.l	#15,d2
		cmp.l	Next_Tile,d2		same pattern ?
		beq.s	.NoCheck_3
		move.b	-12(a0),d2
		lsr.l	#4,d2
		and.l	#15,d2
		cmp.l	Next_Color,d2		same color ?
		beq.s	.NoCheck_3
		bra	.wait			cannot set this !
.NoCheck_3	cmp.b	#6,d1			check out the neighbours
		beq.s	.NoCheck_4
		cmp.b	#-1,12(a0)		occupied ?
		beq.s	.NoCheck_4
		addq.l	#1,Adder		add one to score
		move.b	12(a0),d2		lower one
		and.l	#15,d2
		cmp.l	Next_Tile,d2		same pattern ?
		beq.s	.NoCheck_4
		move.b	12(a0),d2
		lsr.l	#4,d2
		and.l	#15,d2
		cmp.l	Next_Color,d2		same color ?
		beq.s	.NoCheck_4
		bra	.wait			cannot set this !
.NoCheck_4	tst.l	Adder			neighbours there ?
		bne.s	.SetIt
		cmp.l	#4,GameMode		is a neighbour necessary ?
		beq	.wait			cannot set tile alone !
		cmp.l	#5,GameMode
		beq	.wait			cannot set tile alone !
.SetIt		move.l	Next_Color,d0		set new tile
		lsl.l	#4,d0
		or.b	Next_Tile+3,d0
		move.b	d0,(a0)
		cmp.l	#4,Adder		4 neighbours ???
		bne	.NoBonus		no special bonus

		lea	Differents,a1		clear neighbours
		moveq	#5,d0
.ClrNeighbours	move.b	#0,(a1)+
		dbra	d0,.ClrNeighbours
		lea	Differents,a1
		move.b	(a0),d0			count different patterns
		and.l	#15,d0
		move.b	#1,(a1,d0)
		move.b	-1(a0),d0
		and.l	#15,d0
		move.b	#1,(a1,d0)
		move.b	-12(a0),d0
		and.l	#15,d0
		move.b	#1,(a1,d0)
		move.b	1(a0),d0
		and.l	#15,d0
		move.b	#1,(a1,d0)
		move.b	12(a0),d0
		and.l	#15,d0
		move.b	#1,(a1,d0)
		clr.l	d1			calc new score
		moveq	#5,d0
.Count_Patterns	add.b	(a1)+,d1
		dbra	d0,.Count_Patterns
		add.l	d1,Adder		add to adder
		cmp.b	#5,d1			new multiplier ?!?
		bne.s	.NoNewMulti
		cmp.l	#9,Multiplier
		beq.s	.NoNewMulti
		addq.l	#1,Multiplier
.NoNewMulti	lea	Differents,a1		clear neighbours
		moveq	#5,d0
.ClrNeighbours2	move.b	#0,(a1)+
		dbra	d0,.ClrNeighbours2
		lea	Differents,a1
		move.b	(a0),d0			count different colors
		lsr.l	#4,d0
		and.l	#15,d0
		move.b	#1,(a1,d0)
		move.b	-1(a0),d0
		lsr.l	#4,d0
		and.l	#15,d0
		move.b	#1,(a1,d0)
		move.b	-12(a0),d0
		lsr.l	#4,d0
		and.l	#15,d0
		move.b	#1,(a1,d0)
		move.b	1(a0),d0
		lsr.l	#4,d0
		and.l	#15,d0
		move.b	#1,(a1,d0)
		move.b	12(a0),d0
		lsr.l	#4,d0
		and.l	#15,d0
		move.b	#1,(a1,d0)
		lea	Differents,a1		calc new score
		clr.l	d1
		moveq	#5,d0
.CountPatterns2	add.b	(a1)+,d1
		dbra	d0,.CountPatterns2
		add.l	d1,Adder		add to adder
		cmp.b	#5,d1			new multiplier ?!?
		bne.s	.NoNewMulti2
		addq.l	#1,Multiplier
.NoNewMulti2	
.NoBonus	move.l	Adder,d0		add adder*multiplier to score
		move.l	Multiplier,d1
		mulu	d1,d0
		add.l	d0,Score
		bsr	Show_Board		and update board
		bra	Play_Loop		loopieloopieloop
_End		move.l	#1,d0			flag = esc
		rts				end of stage (ESC)

EndOfStage	move.l	#0,d0			flag = solved
		rts

* input string (x/y/buffer/len d0/d1/a0/d2)

Input		move.l	d0,.x
		move.l	d1,.y
		move.l	d2,.maxlen
		move.l	#0,.pos
.loop_1		move.l	a0,-(sp)
		lea	.cursor,a0
		move.l	Plane_1,a1
		add.l	.x,a1
		add.l	.pos,a1
		move.l	.y,d0
		mulu	#40,d0
		add.l	d0,a1
		bsr	Print
		move.l	(sp)+,a0
		move.b	#0,$bfec01
.waitkey	move.b	$bfec01,d0
		beq	.waitkey
.release	btst	#0,$bfec01
		bne	.release
		movem.l	a0/d0,-(sp)
		lea	.space,a0
		move.l	Plane_1,a1
		add.l	.x,a1
		add.l	.pos,a1
		move.l	.y,d0
		mulu	#40,d0
		add.l	d0,a1
		bsr	Print
		movem.l	(sp)+,a0/d0
		cmp.b	#$7d,d0
		beq	.delete
		cmp.b	#$77,d0
		beq	.return
		lea	.keys(pc),a1
		lea	.chars(pc),a2
		moveq	#39,d1
.search		cmp.b	(a1),d0
		beq	.found
		addq.l	#1,a1
		addq.l	#1,a2
		dbra	d1,.search
		bra	.loop_1
.found		move.l	.pos,d1
		cmp.l	.maxlen,d1
		bge	.loop_1
		move.b	(a2),(a0)+
		move.b	(a2),.print
		move.l	a0,-(sp)
		lea	.print,a0
		move.l	Plane_1,a1
		add.l	.x,a1
		add.l	.pos,a1
		move.l	.y,d0
		mulu	#40,d0
		add.l	d0,a1
		bsr	Print
		move.l	(sp)+,a0
		addq.l	#1,.pos
		bra	.loop_1
.delete		tst.l	.pos
		beq	.loop_1
		subq.l	#1,a0
		subq.l	#1,.pos
		movem.l	a0/d0,-(sp)
		lea	.space(pc),a0
		move.l	Plane_1,a1
		add.l	.x,a1
		add.l	.pos,a1
		move.l	.y,d0
		mulu	#40,d0
		add.l	d0,a1
		bsr	Print
		movem.l	(sp)+,a0/d0
		bra	.loop_1
.return		move.b	#0,(a0)
		rts

.pos		ds.l	1
.maxlen		ds.l	1
.x		ds.l	1
.y		ds.l	1
.keys		dc.b	$bf,$95,$99,$bb,$db,$b9,$b7,$b5
		dc.b	$d1,$b3,$b1,$af,$91,$93,$cf,$cd
		dc.b	$df,$d9,$bd,$d7,$d3,$97,$dd,$9b
		dc.b	$9d,$d5,$8d,$8f,$7f,$eb,$fd,$fb
		dc.b	$f9,$f7,$f5,$f3,$f1,$ef,$ed,$8b
		EVEN
.chars		dc.b	"ABCDEFGH"
		dc.b	"IJKLMNOP"
		dc.b	"QRSTUVWX"
		dc.b	"YZ., 012"
		dc.b	"3456789-"
		EVEN
.cursor		dc.b	"#",0
.space		dc.b	" ",0
.print		dc.b	"X",0


* x/y d0/d1

Set_Tile	lea	NormMask,a4		set a tile-gfx
		lea	Tiles,a0		get ptr on gfx
		move.l	Next_Tile,d2
		mulu	#6*5*29*4,d2
		move.l	Next_Color,d3
		mulu	#5*29*4,d3
		add.l	d2,a0
		add.l	d3,a0
		move.l	Plane_2,a1		get ptr on target
		add.l	#2,a1
		mulu	#3,d0
		mulu	#24*40,d1
		add.l	d0,a1
		add.l	d1,a1
		move.l	next_tile,d0
		mulu	#6*29*4,d0
		add.l	d0,a4
		move.l	next_color,d0
		mulu	#29*4,d0
		add.l	d0,a4
		moveq	#4,d0			and show it : 5 BPs
.CopyTile_1	move.l	a1,a2
		moveq	#28,d1			29 lines
.CopyTile_2	move.l	a2,a3
		moveq	#3,d2			3 bytes (24 dots)
.CopyTile_3	moveq	#0,d3
		moveq	#0,d4
		move.b	(a3),d3			or it into plane using
		move.b	(a4),d4			a mask
		eor.b	#$ff,d4
		and.b	d4,d3
		move.b	(a0)+,d4
		and.b	(a4)+,d4
		or.b	d4,d3
		move.b	d3,(a3)+
		dbra	d2,.CopyTile_3
		add.l	#40,a2
		dbra	d1,.CopyTile_2
		sub.l	#29*4,a4
		add.l	#256*40,a1
		dbra	d0,.CopyTile_1
		rts

Show_Board	lea	Board,a0		update board
		move.l	Plane_2,a1		copy board-gfx
		moveq	#4,d7
.Loop_1		move.l	a1,a2
		move.l	#(10*178)-1,d6
.Loop_2		move.l	(a0)+,(a2)+
		dbra	d6,.Loop_2
		add.l	#256*40,a1
		dbra	d7,.Loop_1
		lea	Area+12,a0		show all tiles
		move.l	#11,d0
		move.l	#0,d1
.Show_1		moveq	#0,d2
		move.b	-(a0),d2		occupied ?
		cmp.b	#-1,d2
		beq.s	.Next
		move.l	d2,d3			get ptr on gfx
		and.l	#15,d2
		move.l	d2,Next_Tile
		lsr.l	#4,d3
		and.l	#15,d3
		move.l	d3,Next_Color
		movem.l	d0-d1/a0,-(sp)
		bsr	Set_Tile		copy tile-gfx
		movem.l	(sp)+,d0-d1/a0
.Next		subq.l	#1,d0			next plot,
		cmp.l	#-1,d0
		bne.s	.Show_1
		add.l	#24,a0			next line.
		move.l	#11,d0
		addq.l	#1,d1
		cmp.l	#7,d1
		bne.s	.Show_1
		bsr	WaitBlt
		move.w	#$ffff,BLTAFWM(a5)
		move.w	#$ffff,BLTALWM(a5)
		move.w	#%0000100111110000,BLTCON0(a5)
		move.w	#0,BLTCON1(a5)
		move.w	#0,BLTAMOD(a5)
		move.w	#0,BLTDMOD(a5)
		move.l	Plane_1,d0
		move.l	Plane_2,d1
		moveq	#4,d7			5 BPs
.Blit_1		move.l	d1,BLTAPTH(a5)
		move.l	d0,BLTDPTH(a5)
		move.w	#178*64+20,BLTSIZE(a5)
.WaitBlt_2	btst	#14,DMACONR(a5)
		bne.s	.WaitBlt_2
		add.l	#256*40,d0
		add.l	#256*40,d1
		dbra	d7,.Blit_1
		rts

Create_Mask	lea	Tiles,a0		create mask for the gfx-or
		lea	NormMask,a1
		moveq	#5,d7
.Loop_1		move.l	a0,a2
		moveq	#5,d6
.Loop_2		move.l	a2,a3
		moveq	#28,d5
.Loop_3		move.l	a3,a4
		moveq	#3,d4
.Loop_4		move.b	0*29*4(a4),d0
		or.b	1*29*4(a4),d0
		or.b	2*29*4(a4),d0
		or.b	3*29*4(a4),d0
		or.b	4*29*4(a4),d0
		move.b	d0,(a1)+
		addq.l	#1,a4
		dbra	d4,.Loop_4
		addq.l	#4,a3
		dbra	d5,.Loop_3
		add.l	#5*29*4,a2
		dbra	d6,.Loop_2
		add.l	#6*5*29*4,a0
		dbra	d7,.Loop_1
		rts

Do_Clock	tst.l	Clockflag		count clock
		bne.s	.Do_it			flag set ?
		rts
.Do_it		subq.l	#1,Frames		50 (60) frames done ?!?
		beq.s	.Do_Seconds
		rts
.Do_Seconds	move.b	VBlankFrequency(a6),d0	restore vblank ptr
		ext.w	d0
		ext.l	d0
		move.l	d0,Frames
		subq.l	#1,Seconds		next second...
		beq.s	.Show_Clock
		bpl.s	.Show_Clock
		move.l	#59,Seconds
		subq.l	#1,Minutes		next minute...
.Show_Clock	bsr.s	Show_Clock
		rts

Show_Clock	move.l	Minutes,d0		display minute
		move.l	#1,d1
		moveq	#1,d2
		lea	TextBuffer,a0
		bsr	BinDec
		move.l	Plane_1,a1
		add.l	#184*40+36,a1
		bsr	Print
		move.l	Seconds,d0		... second
		move.l	#2,d1
		moveq	#1,d2
		lea	TextBuffer,a0
		bsr	BinDec
		move.l	Plane_1,a1
		add.l	#184*40+38,a1
		bsr	Print
		rts

CheckMouse	clr.l	d0			do mouse-pointer
		move.w	JOY0DAT(a5),d0
		move.b	prev_x+3,d1		old position
		move.b	d0,prev_x+3
		sub.b	d0,d1
		move.b	d1,d2
		bpl.s	.pos_x
		neg.b	d2
.pos_x		cmp.b	#127,d2			I really HATE this
		ble.s	.No_WrapX		register JOY0DAT !!!
		add.b	#255,d1
.No_WrapX	neg.b	d1
		ext.w	d1
		ext.l	d1
		add.l	d1,ptr_x
		lsr.w	#8,d0
		move.b	prev_y+3,d1
		move.b	d0,prev_y+3
		sub.b	d0,d1
		move.b	d1,d2
		bpl.s	.pos_y
		neg.b	d2
.pos_y		cmp.b	#127,d2
		ble.s	.No_WrapY
		addi.b	#255,d1
.No_WrapY	neg.b	d1
		ext.w	d1
		ext.l	d1
		add.l	d1,ptr_y
		cmp.l	#136,ptr_x		check limits
		bge.s	.no_xreset
		move.l	#136,ptr_x
.no_xreset	cmp.l	#423,ptr_x
		blt.s	.no_xreset_2
		move.l	#422,ptr_x
.no_xreset_2	cmp.l	#50,ptr_y
		bge.s	.no_yreset
		move.l	#50,ptr_y
.no_yreset	cmp.l	#217,ptr_y
		blt.s	.no_yreset_2
		move.l	#216,ptr_y
.no_yreset_2	move.l	Sprite,a0		and set new spritepos
		move.l	ptr_x,d0
		move.l	ptr_y,d1
		move.l	ptr_y,d2
		addq.l	#6,d2
		move.l	#0,d3
		bsr	Set_Spritepos
		rts

BigPrint	moveq	#0,d0			print message (a0/a1)
		move.b	(a0)+,d0
		tst.b	d0			last letter ?
		beq.s	.EndPrint
		sub.b	#$20,d0			get ptr on gfx
		mulu	#3*24*3,d0
		lea	Charset,a2
		add.l	d0,a2
		move.l	a1,a3
		moveq	#2,d0			copy letter (3*24*24 dots)
.CopyLetter_1	move.l	a3,a4
		moveq	#23,d1
.CopyLetter_2	move.b	(a2)+,0(a4)
		move.b	(a2)+,1(a4)
		move.b	(a2)+,2(a4)
		move.l	bpsize,d2
		divu	#256,d2
		add.l	d2,a4
		dbra	d1,.CopyLetter_2
		add.l	bpsize,a3
		dbra	d0,.CopyLetter_1
		addq.l	#3,a1
		bra.s	BigPrint
.EndPrint	rts

Print		moveq	#0,d0			print message (a0/a1)
		move.b	(a0)+,d0
		tst.b	d0			last letter ?
		beq.s	.EndPrint
		sub.b	#$20,d0			get ptr on gfx
		lsl.l	#4,d0
		lea	Font,a2
		add.l	d0,a2
		move.l	a1,a3
		moveq	#15,d0			copy letter (8*16 dots)
.CopyLetter	move.b	(a2)+,(a3)
		move.l	bpsize,d1
		divu	#256,d1
		add.l	d1,a3
		dbra	d0,.CopyLetter
		addq.l	#1,a1
		bra.s	Print
.EndPrint	rts

Show_Next	move.l	#6,d0			create and show next tile
		bsr	Get_RND			get RND-tile
		move.l	d0,Next_Tile
		move.l	#6,d0
		bsr	Get_RND			get RND-color
		move.l	d0,Next_Color
		move.l	Next_Tile,d0
		mulu	#6*5*29*4,d0
		move.l	Next_Color,d1
		mulu	#5*29*4,d1
		add.l	d1,d0
		lea	Tiles,a0		get ptr on gfx
		add.l	d0,a0
		move.l	Plane_1,a1		and on plane
		add.l	#177*40+19,a1
		moveq	#4,d0			copy 5 BPs...
.Loop_1		move.l	a1,a2
		moveq	#28,d1
.Loop_2		move.l	a2,a3
		moveq	#3,d2
.Loop_3		move.b	(a0)+,(a3)+
		dbra	d2,.Loop_3
		add.l	#40,a2
		dbra	d1,.Loop_2
		add.l	#256*40,a1
		dbra	d0,.Loop_1
		move.l	Left,d0			show number of tiles left
		move.l	#2,d1
		moveq	#0,d2
		lea	TextBuffer,a0
		bsr.s	BinDec
		move.l	Plane_1,a1
		add.l	#184*40+28,a1
		bsr	Print
		subq.l	#1,Left
		rts

* Bin to Dec
* a0/d0/d1/d2   ^Buffer/Value/Digits/Zeroflag   =   a0   ^String

BinDec		lea	.Potenzen(pc),a1	convert dx into string
		moveq	#7,d3			8 digits
.next		moveq	#"0",d4			start with zero
.dec		addq	#1,d4			divide...
		sub.l	(a1),d0
		bcc.s	.dec
		subq	#1,d4
		add.l	(a1),d0
		tst.b	d2			leading zero flag set ?
		bne.s	.FlagSet
		cmp.b	#"0",d4			zero ?
		bne.s	.NoZero
		move.b	#" ",d4
		bra.s	.FlagSet
.NoZero		moveq	#1,d2			set leading zero flag
.FlagSet	move.b	d4,(a0)+
		lea	4(a1),a1
		dbra	d3,.Next
		cmp.b	#" ",-1(a0)		number = zero ?
		bne.s	.NotZero
		move.b	#"0",-1(a0)
.NotZero	move.b	#0,(a0)
		sub.l	d1,a0			get ptr on first digit
		rts

.Potenzen	dc.l	10000000
		dc.l	1000000
		dc.l	100000
		dc.l	10000
		dc.l	1000
		dc.l	100
		dc.l	10
		dc.l	1

Set_RND		move.w	$dff006,d0		set new RND-seed
		lsr.w	#3,d0
		swap	d0
		move.w	$dff006,d0
		lsr.w	#1,d0
		move.l	d0,RND_Seed
		rts

Get_RND		move.l	d0,d1			get new RND
		move.l	RND_Seed(pc),d0		(routine taken from
		add.l	d0,d0			and old C-program and
		bhi.s	.Over			changed a bit)
		eor.l	#$1d872b41,d0
.Over		move.w	$dff006,d2
		eor.w	d2,d0
		move.w	$dff006,d2
		swap	d0
		eor.w	d2,d0
		swap	d0
		move.l	d0,RND_Seed
		and.l	#$ffff,d0
		divu	d1,d0
		swap	d0
		ext.l	d0
		rts

RND_Seed	dc.l	$51d0f731

* Sprite-Koordinaten ausrechnen
* a0/d0/d1/d2/d3 - sprite/x/y/lasty/at

Set_Spritepos	move.b	d1,(a0)			set new sprite-pos
		ror.w	#1,d0
		move.b	d0,1(a0)
		move.b	d2,2(a0)
		rol.w	#1,d0
		and.b	#1,d0
		btst	#8,d1
		beq.s	.not_first
		bset	#2,d0
.not_first	btst	#8,d2
		beq.s	.not_second
		bset	#1,d0
.not_second	tst.b	d3
		beq.s	.no_AT
		bset	#7,d0
.no_AT		move.b	d0,3(a0)
		rts

WaitBlt		btst	#14,DMACONR(a5)
		bne.s	WaitBlt
		rts

		SECTION	"Replay",CODE_C

start_muzak	move.l	#data,muzakoffset
init0		move.l	muzakoffset,a0
		add.l	#472,a0
		move.l	#$80,d0
		clr.l	d1
init1		move.l	d1,d2
		subq.w	#1,d0
init2		move.b	(a0)+,d1
		cmp.b	d2,d1
		bgt.s	init1
		dbf	d0,init2
		addq.b	#1,d2
init3		move.l	muzakoffset,a0
		lea	pointers(pc),a1
		lsl.l	#8,d2
		lsl.l	#2,d2
		add.l	#600,d2
		add.l	a0,d2
		moveq	#14,d0
init4		move.l	d2,(a1)+
		clr.l	d1
		move.w	42(a0),d1
		lsl.l	#1,d1
		add.l	d1,d2
		add.l	#30,a0
		dbf	d0,init4
init5		clr.w	$dff0a8
		clr.w	$dff0b8
		clr.w	$dff0c8
		clr.w	$dff0d8
		clr.w	timpos
		clr.l	trkpos
		clr.l	patpos
init6		move.l	muzakoffset,a0
		move.b	470(a0),numpat+1
		move.l	$6c.w,lev3save+2
		move.l	#lev3interrupt,$6c.w
		rts

stop_muzak	move.l	lev3save+2,$6c.w
		clr.w	$dff0a8
		clr.w	$dff0b8
		clr.w	$dff0c8
		clr.w	$dff0d8
		move.w	#$f,$dff096
		rts

lev3interrupt	bsr.s	replay_muzak
lev3save	jmp	$0

replay_muzak	movem.l	d0-d7/a0-a6,-(a7)
		addq.w	#1,timpos
speed		cmp.w	#6,timpos
		beq.w	replaystep
chaneleffects	lea	datach0(pc),a6
		tst.b	3(a6)
		beq.s	ceff1
		lea	$dff0a0,a5
		bsr.s	ceff5
ceff1		lea	datach1(pc),a6
		tst.b	3(a6)
		beq.s	ceff2
		lea	$dff0b0,a5
		bsr.s	ceff5
ceff2		lea	datach2(pc),a6
		tst.b	3(a6)
		beq.s	ceff3
		lea	$dff0c0,a5
		bsr.s	ceff5
ceff3		lea	datach3(pc),a6
		tst.b	3(a6)
		beq.s	ceff4
		lea	$dff0d0,a5
		bsr.s	ceff5
ceff4		movem.l	(a7)+,d0-d7/a0-a6
		rts

ceff5		move.b	2(a6),d0
		and.b	#$f,d0
		tst.b	d0
		beq.s	arpreggiato
		cmp.b	#1,d0
		beq.w	pitchup
		cmp.b	#2,d0
		beq.w	pitchdown
		cmp.b	#12,d0
		beq.w	setvol
		cmp.b	#14,d0
		beq.w	setfilt
		cmp.b	#15,d0
		beq.w	setspeed
		rts

arpreggiato	cmp.w	#1,timpos
		beq.s	arp1
		cmp.w	#2,timpos
		beq.s	arp2
		cmp.w	#3,timpos
		beq.s	arp3
		cmp.w	#4,timpos
		beq.s	arp1
		cmp.w	#5,timpos
		beq.s	arp2
		rts

arp1		clr.l	d0
		move.b	3(a6),d0
		lsr.b	#4,d0
		bra.s	arp4
arp2		clr.l	d0
		move.b	3(a6),d0
		and.b	#$f,d0
		bra.s	arp4
arp3		move.w	16(a6),d2
		bra.s	arp6
arp4		lsl.w	#1,d0
		clr.l	d1
		move.w	16(a6),d1
		lea	notetable,a0
arp5		move.w	(a0,d0.w),d2
		cmp.w	(a0),d1
		beq.s	arp6
		addq.l	#2,a0
		bra.s	arp5
arp6		move.w	d2,6(a5)
		rts

pitchdown	bsr.s	newrou
		clr.l	d0
		move.b	3(a6),d0
		and.b	#$f,d0
		add.w	d0,(a4)
		cmp.w	#$358,(a4)
		bmi.s	ok1
		move.w	#$358,(a4)
ok1		move.w	(a4),6(a5)
		rts

pitchup		bsr.s	newrou
		clr.l	d0
		move.b	3(a6),d0
		and.b	#$f,d0
		sub.w	d0,(a4)
		cmp.w	#$71,(a4)
		bpl.s	ok2
		move.w	#$71,(a4)
ok2		move.w	(a4),6(a5)
		rts

setvol		move.b	3(a6),8(a5)
		rts

setfilt		move.b	3(a6),d0
		and.b	#1,d0
		lsl.b	#1,d0
		and.b	#$fd,$bfe001
		or.b	d0,$bfe001
		rts

setspeed	clr.l	d0
		move.b	3(a6),d0
		and.b	#$f,d0
		move.w	d0,speed+2
		rts

newrou		cmp.l	#datach0,a6
		bne.s	next1
		lea	voi1(pc),a4
		rts
next1		cmp.l	#datach1,a6
		bne.s	next2
		lea	voi2(pc),a4
		rts
next2		cmp.l	#datach2,a6
		bne.s	next3
		lea	voi3(pc),a4
		rts
next3		lea	voi4(pc),a4
		rts

replaystep	clr.w	timpos
		move.l	muzakoffset,a0
		move.l	a0,a3
		add.l	#12,a3
		move.l	a0,a2
		add.l	#472,a2
		add.l	#600,a0
		clr.l	d1
		move.l	trkpos,d0
		move.b	(a2,d0),d1
		lsl.l	#8,d1
		lsl.l	#2,d1
		add.l	patpos,d1
		clr.w	enbits
		lea	$dff0a0,a5
		lea	datach0(pc),a6
		bsr.w	chanelhandler
		lea	$dff0b0,a5
		lea	datach1(pc),a6
		bsr.w	chanelhandler
		lea	$dff0c0,a5
		lea	datach2(pc),a6
		bsr.w	chanelhandler
		lea	$dff0d0,a5
		lea	datach3(pc),a6
		bsr.w	chanelhandler
		move.w	#400,d0
rep1		dbf	d0,rep1
		move.w	#$8000,d0
		or.w	enbits,d0
		move.w	d0,$dff096
		cmp.w	#1,datach0+14
		bne.s	rep2
		clr.w	datach0+14
		move.w	#1,$dff0a4
rep2		cmp.w	#1,datach1+14
		bne.s	rep3
		clr.w	datach1+14
		move.w	#1,$dff0b4
rep3		cmp.w	#1,datach2+14
		bne.s	rep4
		clr.w	datach2+14
		move.w	#1,$dff0c4
rep4		cmp.w	#1,datach3+14
		bne.s	rep5
		clr.w	datach3+14
		move.w	#1,$dff0d4
rep5		add.l	#16,patpos
		cmp.l	#64*16,patpos
		bne.s	rep6
		clr.l	patpos
		addq.l	#1,trkpos
		clr.l	d0
		move.w	numpat,d0
		cmp.l	trkpos,d0
		bne.s	rep6
		clr.l	trkpos
rep6		movem.l	(a7)+,d0-d7/a0-a6
		rts

chanelhandler	move.l	(a0,d1.l),(a6)
		addq.l	#4,d1
		clr.l	d2
		move.b	2(a6),d2
		lsr.b	#4,d2
		beq.s	chan2
		move.l	d2,d4
		lsl.l	#2,d2
		mulu	#30,d4
		lea	pointers-4(pc),a1
		move.l	(a1,d2.l),4(a6)
		move.w	(a3,d4.l),8(a6)
		move.w	2(a3,d4.l),18(a6)
		move.l	d0,-(a7)
		move.b	2(a6),d0
		and.b	#$f,d0
		cmp.b	#$c,d0
		bne.s	ok3
		move.b	3(a6),8(a5)
		bra.s	ok4
ok3		move.w	2(a3,d4.l),8(a5)
ok4		move.l	(a7)+,d0
		clr.l	d3
		move.w	4(a3,d4),d3
		add.l	4(a6),d3
		move.l	d3,10(a6)
		move.w	6(a3,d4),14(a6)
		cmp.w	#1,14(a6)
		beq.s	chan2
		move.l	10(a6),4(a6)
		move.w	6(a3,d4),8(a6)
chan2		tst.w	(a6)
		beq.s	chan4
		move.w	22(a6),$dff096
		tst.w	14(a6)
		bne.s	chan3
		move.w	#1,14(a6)
chan3		bsr.w	newrou
		move.w	(a6),(a4)
		move.w	(a6),16(a6)
		move.l	4(a6),0(a5)
		move.w	8(a6),4(a5)
		move.w	(a6),6(a5)
		move.w	22(a6),d0
		or.w	d0,enbits
		move.w	18(a6),20(a6)
chan4		rts

datach0		ds.w	11
		dc.w	1
datach1		ds.w	11
		dc.w	2
datach2		ds.w	11
		dc.w	4
datach3		ds.w	11
		dc.w	8
voi1		dc.w	0
voi2		dc.w	0
voi3		dc.w	0
voi4		dc.w	0
pointers	ds.l	15
notetable	dc.w	856,808,762,720,678,640,604,570
		dc.w	538,508,480,453,428,404,381,360
		dc.w	339,320,302,285,269,254,240,226  
		dc.w	214,202,190,180,170,160,151,143
		dc.w	135,127,120,113,000
muzakoffset	dc.l	0
trkpos		dc.l	0
patpos		dc.l	0
numpat		dc.w	0
enbits		dc.w	0
timpos		dc.w	0
data		INCBIN	"ram:Ashido_Music.SFX"

		SECTION	"Data",DATA

sprptr		dc.w	0,%0000000110000000
		dc.w	0,%0000001111000000
		dc.w	0,%0000011111100000
		dc.w	0,%0000011111100000
		dc.w	0,%0000001111000000
		dc.w	0,%0000000110000000

Colortable_1	dc.w	1,1,1,1,1,2,1,2,2,2,2,2,2,3,2,3,3,3,3,3,3,4,3,4
		dc.w	4,4,4,4,4,5,4,5,5,5,5,5,5,6,5,6,6,6,6,6,6,7,6,7
		dc.w	7,7,7,7,7,8,7,8,8,8,8,8,8,9,8,9,9,9,9,9,9,10,9,10
		dc.w	10,10,10,10,10,11,10,11,11,11,11,11,11,12,11,12
		dc.w	12,12,12,12,12,13,12,13,13,13,13,13,13,14,13,14
		dc.w	14,14,14,14,14,15,14,15,15,15,15,15,15,14,15,14
		dc.w	14,14,14,14,14,13,14,13,13,13,13,13,13,12,13,12
		dc.w	12,12,12,12,12,11,12,11,11,11,11,11,11,10,11,10
		dc.w	10,10,10,10,10,9,10,9,9,9,9,9,9,8,9,8
		dc.w	8,8,8,8,8,7,8,7,7,7,7,7,7,6,7,6,6,6,6,6,6,5,6,5
		dc.w	5,5,5,5,5,4,5,4,4,4,4,4,4,3,4,3,3,3,3,3,3,2,3,2
		dc.w	2,2,2,2,2,1,2,1,1,1,1,1,1,0,1,0
		dc.w	0
Cols_1		equ	*-Colortable_1
Colortable_2	dc.w	$000,$08f,$f00,$b00,$700,$0c0,$080,$050
		dc.w	$0ba,$087,$054,$00f,$00b,$008,$cc0,$990
		dc.w	$660,$d0d,$909,$606,$222,$950,$740,$530
		dc.w	$777,$555,$444,$d70,$b60,$950,$dad,$000
Colortable_3	dc.w	$000,$66f,$55e,$33c,$22b,$11a,$118,$007

Table_1		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	0<<4!0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1<<4!1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,4<<4!4,-1,-1,-1,-1,5<<4!5,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	2<<4!2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3<<4!3

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,0,-1,-1,-1,-1,-1,-1,-1,-1,1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,4,-1,-1,5,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,2,-1,-1,-1,-1,-1,-1,-1,-1,3,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,0<<4,-1,-1,-1,-1,-1,-1,-1,-1,1<<4,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,4<<4,-1,-1,5<<4,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,2<<4,-1,-1,-1,-1,-1,-1,-1,-1,3<<4,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,2<<4!0,-1,-1,-1,-1,-1,-1,4<<4!3,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,2<<4!1,-1,-1,-1,-1,-1,-1,4<<4!4,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,2<<4!2,-1,-1,-1,-1,-1,-1,4<<4!5,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,0<<4!1,-1,1<<4!1,-1,2<<4!1,-1,3<<4!4,-1,4<<4!4,-1,5<<4!4
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,5,-1,-1,-1,-1,-1,-1,-1,-1,4,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,2<<4!1,2<<4!0,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,2,-1,-1,-1,-1,-1,-1,-1,-1,3,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,0<<4!1,1<<4!1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,2<<4!3,3<<4!3,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,4<<4!5,5<<4!5,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,2<<4!2,3<<4!2,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,0<<4!0,-1,-1,1<<4!0,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,4<<4!4,4<<4!4,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,1<<4!0,-1,-1,-1,-1,-1,-1,3<<4!3,-1,-1
		dc.b	-1,-1,1<<4!1,-1,-1,-1,-1,-1,-1,3<<4!4,-1,-1
		dc.b	-1,-1,1<<4!2,-1,-1,-1,-1,-1,-1,3<<4!5,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,0<<4!3,1<<4!3,2<<4!3,3<<4!3,4<<4!3,5<<4!3,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,5<<4!1,5<<4!2,5<<4!3,5<<4!4,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,5<<4!0,-1,-1,5<<4!5,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,3<<4!0,3<<4!1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,3<<4!2,3<<4!3,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,3<<4!4,3<<4!5,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,3<<4!0,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,1<<4!0,0<<4!0,2<<4!0,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,4<<4!0,-1,-1,-1,-1,-1
		dc.b	-1,0<<4!0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,4<<4!4,-1,-1,4<<4!1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,4<<4!5,4<<4!0,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,4<<4!3,-1,-1,4<<4!2,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

		dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,0<<4!1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,1<<4!1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,2<<4!1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,3<<4!1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,4<<4!1,-1,-1,-1,-1,-1,-1
		dc.b	-1,-1,-1,-1,-1,-1,5<<4!1,-1,-1,-1,-1,-1
		even

Board		incbin	ram:Ashido_Board.GFX
Tiles		incbin	ram:Ashido_Tiles.GFX
Font		incbin	ram:Ashido_Font.GFX
Charset		incbin	ram:Ashido_Chars.GFX

GfxName		dc.b	"graphics.library",0
		even
DosName		dc.b	"dos.library",0
		even
Error_text	dc.b	"?Not enough CHIPMEM to run program",10
Error_len	equ	*-Error_text
		even
Filename	dc.b	"Ashido.SCO",0
		even
Statusline	dc.b	"SCORE  #      TILE     LEFT    TIME  :  ",0
		even
TitleLine_1	dc.b	" * ASHIDO *",0
		even
GetReady_text	dc.b	"               GET READY!",0
		even
GameOver_text	dc.b	"               GAME OVER! ",0
		even
GameOver_Score	dc.b	"           YOUR SCORE :                 ",0
		even
High_text_1	dc.b	" VERY GOOD, YOU HAVE MADE A HIGHSCORE ! ",0
		even
High_text_2	dc.b	"YOUR NAME, PLEASE:",0
		even
Anonymous_text	dc.b	"AN ANONYMOUS COWARD ",0
		even
Good_text	dc.b	"            CONGRATULATIONS!",0
		even
Good_text_2	dc.b	"          YOU SOLVED THE STAGE.",0
		even
Bonus_text	dc.b	"           TIME BONUS :",0
		even
Page_1		dc.b	"             --- ASHIDO ---             ",0
		dc.b	"                                        ",0
		dc.b	"  CREATED BY ANDRE WICHMANN OF CLUSTER  ",0
		dc.b	"                                        ",0
		dc.b	"  DESIGN, CODE, GFX AND SFX BY ARAGORN  ",0
		dc.b	"                                        ",0
		dc.b	" @ BY ARAGORN [AW] OF CLUSTER DEC 1990. ",0
		dc.b	"                                        ",0
		even
Page_2		dc.b	"                                        ",0
		dc.b	"                                        ",0
		dc.b	"            F1    FREESTYLE             ",0
		dc.b	"            F2    SCORER                ",0
		dc.b	"            F3    EXPLORER              ",0
		dc.b	"            F4    PIONEER               ",0
		dc.b	"            F5    HERO                  ",0
		dc.b	"            F6    EINSTEIN              ",0
		even
Page_3		dc.b	"ASHIDO IS FREEWARE AND MAY BE COPIED IF ",0
		dc.b	"                                        ",0
		dc.b	"  NO CHANGES ARE MADE, THE DOC-FILE IS  ",0
		dc.b	"                                        ",0
		dc.b	" INCLUDED AND *NO* PROFIT IS MADE WITH  ",0
		dc.b	"                                        ",0
		dc.b	"DISTRIBUTION.CONTACT ADDRESS (CLUSTER) :",0
		dc.b	"                                        ",0
Page_4		dc.b	"        ANDRE WICHMANN (ARAGORN)        ",0
		dc.b	"                                        ",0
		dc.b	"             POSENER WEG 4              ",0
		dc.b	"                                        ",0
		dc.b	"              5300 BONN 1               ",0
		dc.b	"                                        ",0
		dc.b	"             WEST GERMANY               ",0
		dc.b	"                                        ",0
		even

Modi		dc.b	"          GAME MODE: FREESTYLE          ",0
		dc.b	"           GAME MODE: SCORER            ",0
		dc.b	"          GAME MODE: EXPLORER           ",0
		dc.b	"           GAME MODE: PIONEER           ",0
		dc.b	"            GAME MODE: HERO             ",0
		dc.b	"          GAME MODE: EINSTEIN           ",0
		even

High_strings	dc.b	"       FREESTYLE HALL OF POINTS:        ",0
		dc.b	"         SCORER'S HALL OF FAME:         ",0
		dc.b	"      EXPLORER'S HALL OF RULERS:       ",0
		dc.b	"        PIONEER'S HALL OF HEROS:        ",0
		dc.b	"     THE HERO'S HALL OF CHAMPIONS:      ",0
		dc.b	"   EINSTEIN'S HALL OF REINCARNATIONS:   ",0
		even

Highscores	dc.l	1000
		dc.b	"ANDRE WICHMANN      "
		dc.l	800
		dc.b	"CLUSTER             "
		dc.l	600
		dc.b	"HAWK                "
		dc.l	400
		dc.b	"ARAGORN             "
		dc.l	200
		dc.b	"CLUSTER             "
		dc.l	100
		dc.b	"HAWK                "

		dc.l	1000
		dc.b	"ANDRE WICHMANN      "
		dc.l	800
		dc.b	"CLUSTER             "
		dc.l	600
		dc.b	"HAWK                "
		dc.l	400
		dc.b	"ARAGORN             "
		dc.l	200
		dc.b	"CLUSTER             "
		dc.l	100
		dc.b	"HAWK                "

		dc.l	1000
		dc.b	"ANDRE WICHMANN      "
		dc.l	800
		dc.b	"CLUSTER             "
		dc.l	600
		dc.b	"HAWK                "
		dc.l	400
		dc.b	"ARAGORN             "
		dc.l	200
		dc.b	"CLUSTER             "
		dc.l	100
		dc.b	"HAWK                "

		dc.l	1000
		dc.b	"ANDRE WICHMANN      "
		dc.l	800
		dc.b	"CLUSTER             "
		dc.l	600
		dc.b	"HAWK                "
		dc.l	400
		dc.b	"ARAGORN             "
		dc.l	200
		dc.b	"CLUSTER             "
		dc.l	100
		dc.b	"HAWK                "

		dc.l	1000
		dc.b	"ANDRE WICHMANN      "
		dc.l	800
		dc.b	"CLUSTER             "
		dc.l	600
		dc.b	"HAWK                "
		dc.l	400
		dc.b	"ARAGORN             "
		dc.l	200
		dc.b	"CLUSTER             "
		dc.l	100
		dc.b	"HAWK                "

		dc.l	1000
		dc.b	"ANDRE WICHMANN      "
		dc.l	800
		dc.b	"CLUSTER             "
		dc.l	600
		dc.b	"HAWK                "
		dc.l	400
		dc.b	"ARAGORN             "
		dc.l	200
		dc.b	"CLUSTER             "
		dc.l	100
		dc.b	"HAWK                "

Empty_line	dc.b	"                                        ",0
		even

Text		dc.b	" WELCOME TO *ASHIDO*, A NEW GAME CREATED BY CLUSTER"
		dc.b	" IN DECEMBER 1990. DESIGN, CODE, GRAPHICS AND MUSIC"
		dc.b	" WAS MADE BY ANDRE WICHMANN, TESTING WAS DONE BY"
		dc.b	" MARTIN MOHR. THIS GAME IS FREEWARE AND MAY BE"
		dc.b	" COPIED/SPREAD IF NO CHANGES ARE MADE, THE DOC-FILE"
		dc.b	" IS INCLUDED AND -NO- PROFIT IS MADE WITH"
		dc.b	" DISTRIBUTION. CONTACT ADDRESS:     ANDRE WICHMANN,"
		dc.b	" POSENER WEG 4, 5300 BONN 1, WEST GERMANY.     "
		dc.b	" SOME HELLOS ARE GOING TO:     ALL MEMBERS OF HAWK"
		dc.b	" (BE PATIENT !) - MADISON (YOUR NEW TUNE IS REALLY"
		dc.b	" COOL, KEEP ON WORKING !) - ANDRE/PDP (SORRY FOR"
		dc.b	" THE LONG DELAY, BUT MY AMIGA WAS OUT OF ORDER AND"
		dc.b	" THE REPAIR TOOK MUCH TIME AND WAS VERY EXPENSIVE.I HOPE"
		dc.b	" THAT I WILL GET THE NEXT MAGS FROM YOU ?) - M.HELBER"
		dc.b	" (I LIKE YOUR DREAMING, BUT IT IS A LITTLE BIT SHORT,"
		dc.b	" ISN'T IT ? KEEP ON WRITING !) - T.CARTER/CANADA"
		dc.b	" (I HOPE THAT YOU LIKE MY NEW PROGRAMS, ESPECIALLY"
		dc.b	" PIPELINE II !) - TILL/NK (YOU WILL LIKE CONQUEST !)"
		dc.b	" GATOR AND POSSESSED OF AFL (?) (STILL TRYING TO BECOME"
		dc.b	" FAMOUS ?!?) - HCF (I LIKED YOUR QUIZ ! AND WRITE TO"
		dc.b	" COMMODORE !) - WONKO THE SANE (WHY NOT WRITING"
		dc.b	" A GAME ?) - IRON (I LIKE AMOS, BUT ASSEMBLER IS"
		dc.b	" BETTER. AND: WHICH WAY OUT ???) AND TO ALL AMIGA-"
		dc.b	" AND RPG-FREAKS AROUND THE WORLD.          "
		dc.b	" DO YOU KNOW PDP, A RATHER NICE PD-MAGAZINE ?"
		dc.b	" USEFUL PD-PROGRAMS AND SOME MORE OR LESS INTERESTING"
		dc.b	" ARTICLES ARE PUBLISHED BY THIS MAG, IF YOU WANT TO"
		dc.b	" HAVE A COPY OF ONE, SEND A DISK EITHER TO ME OR TO THE CREATORS"
		dc.b	" OF PDP:     PLK 117828 C, 5400 KOBLENZ, WEST GERMANY."
		dc.b	" ALL ARTICLES ARE WRITTEN IN GERMAN AND ALL PROGRAMS"
		dc.b	" WERE PACKED WITH THE POWER-PACKER TO PUT AS MUCH"
		dc.b	" PROGRAMS AS POSSIBLE ON THE DISKS.IT IS A RATHER NEW"
		dc.b	" MAG AND NOT A COMMERCIAL ONE, SO GIVE IT A CHANCE !"
		dc.b	"     (HEY ANDRE/PDP, WAS THAT ADVERTISING ENOUGH ?)"
		dc.b	"     IF YOU WANT TO HAVE OTHER PROGRAMS FROM CLUSTER,"
		dc.b	" SEND A DISK EITHER TO ME OR TO GUIDO WEGENER,"
		dc.b	" EISENACHERSTR. 2, 5300 BONN 1, WEST GERMANY. PROGRAMS"
		dc.b	" AVAILABLE:     PIPELINE AND PIPELINE II (A REALLY NICE"
		dc.b	" GAME !), BRAIN (SMALL MULTITASKING-GAME), ASHIDO (THIS"
		dc.b	" GAME HERE !), NEWBOOT (BOOTBLOCK WITH (OPTIONAL)"
		dc.b	" NOFASTMEM, BLITZTEXT, MAXSIZE AND NO-NTSC), FILESELECT V2"
		dc.b	" (A SMALL BUT COOL FILE-REQUEST WITH SOME NEW FEATURES),"
		dc.b	" BLOB (A JOKE), MEGATEXTER (TO CREATE END- AND SENSE-LESS"
		dc.b	" SCROLLS), X-GRAMS (TO DRAW OCTA-, PENTA-, HEPTA-, ...,"
		dc.b	" XTA-GRAMS), WA-TOR (A SIMULATION OF THE POPULATION OF"
		dc.b	" FISHES AND SHARKS, SEE SCIENTIFIC AMERICAN) AND SOME"
		dc.b	" OTHER STUFF SOON FINISHED LIKE CONQUEST (THE ULTIMATE"
		dc.b	" STRATEGIC GAME) OR AN ADVENTURE-INTERPRETER (A LANGUAGE"
		dc.b	" TO CREATE ADVENTURES). YOU CAN FIND SOME OF THESE"
		dc.b	" PROGRAMS ALSO ON SOME FISH-DISKS.          "
		dc.b	" DO YOU LIKE ROLE-PLAYING GAMES ??? I DO NOT ONLY MEAN"
		dc.b	" COMPUTER ROLE-PLAYING GAMES BUT RPG-SYSTEMS LIKE SDL,"
		dc.b	" AD&D, DSA, MERS, MIDGARD ETC.   WE IN CLUSTER ARE FANATIC"
		dc.b	" ROLE-PLAYERS AND WANT TO HAVE CONTACT TO MORE RPG-PLAYERS."
		dc.b	" SO FEEL FREE TO SEND US A LETTER IF YOU ALSO LIKE"
		dc.b	" PLAYING THAT STUFF ! I WONDER WHY ROLE-PLAYING GAMES ARE"
		dc.b	" THAT UNKNOWN IN GERMANY. IN THE USA AD&D IS PLAYED EVERY"
		dc.b	"WHERE, BUT HERE IN GERMANY EVERYBODY THINKS ABOUT THEATRES"
		dc.b	" IF THEY HERE THE WORD 'ROLE-PLAYING'...          "
		dc.b	" BY THE WAY, I INCLUDED A CHEAT-MODE TO TEST THIS GAME. TRY"
		dc.b	" TO FIND IT ! IF YOU ARE ABLE TO PROGRAM ASSEMBLER YOU ONLY"
		dc.b	" HAVE TO TAKE A DEEP LOOK INTO THE SOURCE-CODE AND YOU WILL"
		dc.b	" CHECK IT OUT...I ALSO INCLUDED ONE IN PIPELINE II, BECAUSE"
		dc.b	" I THOUGHT, WHY SHOULD CHEAT-MODES ONLY BE INCLUDED IN"
		dc.b	" COMMERCIAL GAMES ??? BUT I HOPE THAT IT IS NOT USED"
		dc.b	" TO GET HYPER-SCORES...          "
		dc.b	" SEE YOU, GUYS...     SIGNED ARAGORN [AW]...     "
		dc.b	" 'HAU WEG DIE SCHEISSE !' (WERNER)               "
		dc.b	"                    ",0
		even

		SECTION	"Buffers",BSS

DosBase		ds.l	1
Mem		ds.l	1
Plane_1		ds.l	1
Plane_2		ds.l	1
Copper		ds.l	1
Sprite		ds.l	1
Empty		ds.l	1
ptr_x		ds.l	1
ptr_y		ds.l	1
prev_x		ds.l	1
prev_y		ds.l	1
Next_Tile	ds.l	1
Next_Color	ds.l	1
NormMask	ds.b	6*6*29*4
Minutes		ds.l	1
Seconds		ds.l	1
Frames		ds.l	1
Left		ds.l	1
TextBuffer	ds.b	64
Area		ds.b	12*7
Clockflag	ds.l	1
Scrollflag	ds.l	1
Smooth		ds.l	1
vektor		ds.l	1
Score		ds.l	1
Adder		ds.l	1
Multiplier	ds.l	1
Differents	ds.b	6
bpsize		ds.l	1
GameMode	ds.l	1
Colorflag	ds.l	1
Stage		ds.l	1
Hiptr		ds.l	1

